<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:include href="xquestlib.xsl"/>
<xsl:output method="html" encoding="UTF-8" omit-xml-declaration="yes" 
  doctype-public = "-//W3C//DTD HTML 4.01 Transitional//EN"
  doctype-system = "http://www.w3.org/TR/html4/loose.dtd"
/>

<!-- Wurzelknoten -->
<xsl:template match="questionnaire">
  <xsl:variable name="sectioncount" select="count(//section)" />
  <html>
  <head>
    <title><xsl:value-of select="$title"/></title>
    <xsl:call-template name="print_css_style"/>
    <script type="text/javascript"><xsl:comment>
      function endis(id1, id2) {
        div1=document.getElementById(id1);
        div1.style.display="block";
        div2=document.getElementById(id2);
        div2.style.display="none";
        window.scrollTo(0,0);
      }

      function init() {
        q = document.getElementById('buttons1');
        if (q)
          q.style.display="block";
      	i=2;
	while ( q = document.getElementById('sect'+i) ) {
          q.style.display="none";
          q = document.getElementById('buttons'+i);
          q.style.display="block";
          i++;
        }
      <xsl:if test="$with-progress">
	set(1)
      </xsl:if>
      }
      <xsl:if test="$with-progress">
      function set(i) {
 	bar = document.getElementById("progress");
	tds = bar.getElementsByTagName("td");
	var k = 0;
	while (k &lt; i){
	  tds[k].className = "progon";
          k++;
	}
	while(k &lt; <xsl:value-of select="number($sectioncount)"/>){
	  tds[k].className = "progoff";
	  k++;
	}			
      }     
      </xsl:if>
      </xsl:comment>
    </script>
  </head>
  <body onload="javascript:init();">
      <h1><xsl:value-of select="$title"/></h1>

      <xsl:if test="$with-ids">
        <h1><font color="red">Mit Ausgabe der Fragennummern</font></h1>
      </xsl:if>

      <form method="post">
      <xsl:attribute name="action"><xsl:value-of select="$submiturl"/></xsl:attribute>

      <xsl:if test="@restrict='inline'">
        <div class="question>">
        <div class="qtext" style="text-align:center;">ID</div>
        <div class="atext" style="text-align:center;">
        <input name="r1" size="4" maxlength="4"/>-
        <input name="r2" size="4" maxlength="4"/>-
        <input name="r3" size="4" maxlength="4"/>-
        <input name="r4" size="4" maxlength="4"/>
        </div>
        </div>
      </xsl:if>
      <xsl:if test="@restrict='inline_short'">
        <div class="question>">
        <div class="qtext" style="text-align:center;">ID</div>
        <div class="atext" style="text-align:center;">
        <input name="id" size="6" maxlength="6"/>
        </div>
        </div>
      </xsl:if>
      <xsl:if test="@restrict='url'">
        <script language="php">echo "&lt;input type='hidden' name='id' value='$_GET[id]' /&gt;"; </script>
      </xsl:if>

      <!-- restrict=user braucht keine Behandlung -->

      <xsl:if test="$with-time">
        <script language="php">echo "&lt;input type='hidden' name='xquest_start' value='".time()."' /&gt;"; </script>
      </xsl:if>

      <xsl:if test="$with-progress">
	<div id="ShowProgressbar">
	<table style="border:1px solid black;">
	<tr valign="center" id="progress">
	  <xsl:for-each select="section">
	  <td class="progoff"><xsl:text>&#160;&#160;</xsl:text></td>
	  </xsl:for-each>
	</tr>
	</table>
        </div>
      </xsl:if>

      <xsl:apply-templates/>

      <xsl:choose>
        <xsl:when test="//submit"> <!-- es gibt irgendwo im xml ein submit, -->
        </xsl:when>                <!-- dann wird es automatisch ausgegeben an jener stelle -->
        <xsl:otherwise> <!-- es gab kein submit -->
          <p><input type="submit"/></p>
        </xsl:otherwise>
      </xsl:choose>
      </form>
    <xsl:call-template name="print_copyright"/>
  </body>
  </html>
</xsl:template>

<xsl:template match="submit">
  <p>
  <input><xsl:attribute name="type">submit</xsl:attribute>
    <xsl:if test="@value"><xsl:attribute name="value"><xsl:value-of select="@value"/></xsl:attribute></xsl:if>
  </input>
  </p>
</xsl:template>

<!-- Fragetypen -->
<!-- Einfache Auswahlen -->

<xsl:template match="selectquestion">
  <xsl:variable name="fnum"><xsl:call-template name="fnum"/></xsl:variable>

  <div class="question">
  <xsl:call-template name="print_qtext"/>
  <div class="atext">
    <xsl:if test="$with-ids and @type!='or'">
      <span class="fnum">[<xsl:value-of select="$fnum"/>]</span>
      <xsl:if test="@type='xor'">
        <br/>
      </xsl:if>
    </xsl:if>
     <xsl:choose>
      <xsl:when test="@type='dropdown'">
        <select name="{$fnum}">
          <xsl:apply-templates select="atext">
            <xsl:with-param name="fnum" select="$fnum"/>
          </xsl:apply-templates>
        </select>
      </xsl:when>
      <xsl:otherwise>
        <xsl:apply-templates select="atext"/>
      </xsl:otherwise>
    </xsl:choose>
  </div>
  </div>
</xsl:template>

<xsl:template match="selectquestion[@type='or']/atext">
  <xsl:variable name="fnum">
    <xsl:call-template name="fnum">
      <xsl:with-param name="default">f<xsl:call-template name="qcounter"/>_<xsl:number count="atext"/></xsl:with-param>
    </xsl:call-template>
  </xsl:variable>

  <xsl:call-template name="input-tag">
    <xsl:with-param name="type">checkbox</xsl:with-param>
    <xsl:with-param name="name" select="$fnum"/>
    <xsl:with-param name="value">1</xsl:with-param>
  </xsl:call-template>
                                                                                     
  <xsl:if test="$with-ids">
    <span class="fnum">[<xsl:value-of select="$fnum"/>]</span>
  </xsl:if>
  <xsl:apply-templates/><br/>
</xsl:template>

<xsl:template match="selectquestion[@type='xor']/atext">
  <xsl:variable name="fnum">
    <xsl:choose>
      <xsl:when test="../@id"><xsl:value-of select="../@id"/></xsl:when>
      <xsl:otherwise>f<xsl:call-template name="qcounter"/></xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <xsl:call-template name="input-tag">
    <xsl:with-param name="type">radio</xsl:with-param>
    <xsl:with-param name="name" select="$fnum"></xsl:with-param>
    <xsl:with-param name="value"><xsl:call-template name="aval"/></xsl:with-param>
  </xsl:call-template>
  <xsl:apply-templates/><br/>
</xsl:template>

<xsl:template match="selectquestion[@type='xor' or @type='or']/atext/input">
  <xsl:variable name="fnum">
    <xsl:choose>
      <xsl:when test="(../../@type='or' and ../@id) or (../../@type='xor' and ../../@id)">
        <xsl:if test="../../@type='or'"><xsl:value-of select="../@id"/>_txt</xsl:if>
        <xsl:if test="../../@type='xor'"><xsl:value-of select="../../@id"/>_txt</xsl:if>
      </xsl:when>
      <xsl:otherwise>f<xsl:call-template name="qcounter"/>_<xsl:number count="atext"/>_txt</xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <xsl:call-template name="textinput-tag">
    <xsl:with-param name="name" select="$fnum"/>
  </xsl:call-template>
</xsl:template>

<xsl:template match="selectquestion[@type='dropdown']/atext">
  <xsl:param name="fnum"/>
  <xsl:call-template name="option-tag">
    <xsl:with-param name="value"><xsl:call-template name="aval"/></xsl:with-param>
  </xsl:call-template>
</xsl:template>

<!-- Einzeilige Texteingabe -->

<xsl:template match="textquestion">
  <xsl:variable name="fnum"><xsl:call-template name="fnum"/></xsl:variable>
  <div class="question">
  <xsl:call-template name="print_qtext"/>
  <xsl:choose>
    <xsl:when test="descendant::input">
       <xsl:apply-templates select="atext"/>
    </xsl:when>
    <xsl:otherwise>
      <div class="atext">
      <xsl:call-template name="textinput-tag">
        <xsl:with-param name="name" select="$fnum"/>
      </xsl:call-template>
      </div>
    </xsl:otherwise>
  </xsl:choose>
  </div>
</xsl:template>

<xsl:template match="textquestion/atext">
  <div class="atext">
    <xsl:apply-templates />
  </div>
</xsl:template>

<xsl:template match="textquestion/atext/input">
  <xsl:variable name="fnum">
    <xsl:call-template name="fnum">
      <xsl:with-param name="default">
        <xsl:text>f</xsl:text>
        <xsl:call-template name="qcounter"/>
        <xsl:if test="count(../../atext/input) &gt; 1">
          <xsl:text>_</xsl:text>
          <xsl:value-of select="count(../preceding-sibling::atext/input | preceding-sibling::input) + 1"/>
        </xsl:if>
      </xsl:with-param>
    </xsl:call-template>
  </xsl:variable>

  <xsl:call-template name="textinput-tag">
    <xsl:with-param name="name" select="$fnum"/>
  </xsl:call-template>
</xsl:template>


<!-- Mehrzeilige Texteingabe -->

<xsl:template match="textareaquestion">
  <xsl:variable name="fnum"><xsl:call-template name="fnum"/></xsl:variable>

  <div class="question">
  <xsl:call-template name="print_qtext"/>
  <div class="atext">
    <xsl:if test="$with-ids">
      <span class="fnum">[<xsl:value-of select="$fnum"/>]</span>
    </xsl:if>
    <textarea>
      <xsl:attribute name="name"><xsl:value-of select="$fnum"/></xsl:attribute>
      <xsl:attribute name="cols"><xsl:choose>
        <xsl:when test="@cols"><xsl:value-of select="@cols"/></xsl:when>
        <xsl:otherwise>80</xsl:otherwise>
      </xsl:choose></xsl:attribute>
      <xsl:attribute name="rows"><xsl:choose>
        <xsl:when test="@rows"><xsl:value-of select="@rows"/></xsl:when>
        <xsl:otherwise>10</xsl:otherwise>
      </xsl:choose></xsl:attribute>
    </textarea>
  </div>
  </div>
</xsl:template>

<!-- Auswahlbereich -->

<xsl:template match="rangequestion">
  <xsl:variable name="fnum"><xsl:call-template name="fnum"/></xsl:variable>

  <div class="question">
  <xsl:call-template name="print_qtext"/>
  <div class="atext">
    <xsl:if test="$with-ids">
      <span class="fnum">[<xsl:value-of select="$fnum"/>]</span>
    </xsl:if>
    <xsl:value-of select="@left"/>
    <xsl:call-template name="erzeuge_radio">
      <xsl:with-param name="anzahl" select="@count"/>
      <xsl:with-param name="name" select="$fnum"/>
    </xsl:call-template>
    <xsl:value-of select="@right"/>
  </div>
  </div>
</xsl:template>


<xsl:template name="erzeuge_radio">
  <xsl:param name="anzahl"/>
  <xsl:param name="name"/>
  <xsl:if test="$anzahl > 0">
    <xsl:call-template name="erzeuge_radio">
      <xsl:with-param name="anzahl" select="$anzahl - 1"/>
      <xsl:with-param name="name" select="$name"/>
    </xsl:call-template>
    <xsl:call-template name="input-tag">
      <xsl:with-param name="type">radio</xsl:with-param>
      <xsl:with-param name="name" select="$name"/>
      <xsl:with-param name="value" select="$anzahl"/>
    </xsl:call-template>
   </xsl:if>
</xsl:template>

<!-- Matrixfrage -->

<xsl:template match="matrixquestion">
  <div class="question">
  <xsl:call-template name="print_qtext"/>
  <div class="atext">
  <table border="1">
  <tr><td></td><xsl:apply-templates select="columns" mode="head"/></tr>
  <xsl:apply-templates select="rows"/>
  </table>
  </div>
  </div>
</xsl:template>

<xsl:template match="columns" mode="head">
  <xsl:apply-templates select="atext" mode="head"/>
</xsl:template>

<xsl:template match="matrixquestion/columns/atext" mode="head">
  <xsl:variable name="fnum">
    <xsl:choose>
      <xsl:when test="@id"><xsl:value-of select="@id"/></xsl:when>
      <xsl:otherwise>f<xsl:call-template name="qcounter"/>_<xsl:number/></xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <td align="center">
    <xsl:if test="$with-ids and ../../@type='xorr'">
      <span class="fnum">[<xsl:value-of select="$fnum"/>]</span>
    </xsl:if>
    <xsl:apply-templates/>
  </td>
</xsl:template>

<xsl:template match="matrixquestion/rows">
  <xsl:for-each select="atext">
    <xsl:variable name="rnumber"><xsl:call-template name="aval"/></xsl:variable>
    <tr><td><xsl:number format="a"/>) <xsl:apply-templates select="." mode="head"/></td>
      <xsl:apply-templates select="../../columns/atext" mode="body">
         <xsl:with-param name="rnumber" select="$rnumber"/>
      </xsl:apply-templates>
    </tr>
  </xsl:for-each>
</xsl:template>

<xsl:template match="matrixquestion/rows/atext" mode="head">
  <xsl:variable name="fnum">
    <xsl:choose>
      <xsl:when test="@id"><xsl:value-of select="@id"/></xsl:when>
      <xsl:otherwise>f<xsl:call-template name="qcounter"/>_<xsl:number/></xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
 
  <xsl:if test="$with-ids and ../../@type='xorc'">
    <span class="fnum">[<xsl:value-of select="$fnum"/>]</span>
  </xsl:if>
  <xsl:apply-templates/>
</xsl:template>

<xsl:template match="matrixquestion[@type='text']/columns/atext" mode="body">
  <xsl:param name="rnumber">0</xsl:param>
  <xsl:variable name="cnumber"><xsl:number/></xsl:variable>
  <xsl:variable name="fnum">
    <xsl:choose>
      <xsl:when test="../../@id"><xsl:value-of select="../../@id"/></xsl:when>
      <xsl:otherwise>f<xsl:call-template name="qcounter"/></xsl:otherwise>
    </xsl:choose>
    <xsl:text>_</xsl:text>
    <xsl:value-of select="$rnumber"/>
    <xsl:text>_</xsl:text>
    <xsl:value-of select="$cnumber"/>
  </xsl:variable>
 
  <td align="center">
    <xsl:call-template name="textinput-tag">
      <xsl:with-param name="name" select="$fnum"/>
    </xsl:call-template>
  </td>
</xsl:template>

<xsl:template match="matrixquestion[@type='or']/columns/atext" mode="body">
  <xsl:param name="rnumber">0</xsl:param>
  <xsl:variable name="cnumber"><xsl:number/></xsl:variable>
  <xsl:variable name="fnum">
    <xsl:choose>
      <xsl:when test="../../@id"><xsl:value-of select="../../@id"/></xsl:when>
      <xsl:otherwise>f<xsl:call-template name="qcounter"/></xsl:otherwise>
    </xsl:choose>
    <xsl:text>_</xsl:text>
    <xsl:value-of select="$rnumber"/>
    <xsl:text>_</xsl:text>
    <xsl:value-of select="$cnumber"/>
  </xsl:variable>

  <td align="center">
    <xsl:if test="$with-ids">
      <span class="fnum">[<xsl:value-of select="$fnum"/>]</span>
    </xsl:if>
    <xsl:call-template name="input-tag">
      <xsl:with-param name="type">checkbox</xsl:with-param>
      <xsl:with-param name="value">1</xsl:with-param>
      <xsl:with-param name="name" select="$fnum"/>
    </xsl:call-template>
  </td>
</xsl:template>

<xsl:template match="matrixquestion[@type='dropdown']/columns/atext" mode="body">
  <xsl:param name="rnumber">0</xsl:param>
  <xsl:variable name="cnumber"><xsl:number/></xsl:variable>
  <xsl:variable name="fnum">
    <xsl:choose>
      <xsl:when test="../../@id"><xsl:value-of select="../../@id"/></xsl:when>
      <xsl:otherwise>f<xsl:call-template name="qcounter"/></xsl:otherwise>
    </xsl:choose>
    <xsl:text>_</xsl:text>
    <xsl:value-of select="$rnumber"/>
    <xsl:text>_</xsl:text>
    <xsl:value-of select="$cnumber"/>
  </xsl:variable>

  <td align="center">
    <xsl:if test="$with-ids">
      <span class="fnum">[<xsl:value-of select="$fnum"/>]</span>
    </xsl:if>
    <select name="{$fnum}">
     <xsl:apply-templates select="../../fields/atext">
       <xsl:with-param name="fnum" select="$fnum"/>
     </xsl:apply-templates>
    </select>
  </td>
</xsl:template>

<xsl:template match="fields/atext">
  <xsl:param name="fnum"/>
  <xsl:call-template name="option-tag">
    <xsl:with-param name="value"><xsl:call-template name="aval"/></xsl:with-param>
  </xsl:call-template>
</xsl:template>


<xsl:template match="matrixquestion[@type='xorc']/columns/atext" mode="body">
  <xsl:param name="rnumber">0</xsl:param>
  <xsl:variable name="cnumber"><xsl:number/></xsl:variable>
  <xsl:variable name="val"><xsl:call-template name="aval"/></xsl:variable>
  <xsl:variable name="fnum">
    <xsl:choose>
      <xsl:when test="../../rows/atext[number($rnumber)]/@id"><xsl:value-of select="../../rows/atext[number($rnumber)]/@id"/></xsl:when>
      <xsl:otherwise>f<xsl:call-template name="qcounter"/>_<xsl:value-of select="$rnumber"/></xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <td align="center">
  <xsl:call-template name="input-tag">
    <xsl:with-param name="type">radio</xsl:with-param>
    <xsl:with-param name="name" select="$fnum"/>
    <xsl:with-param name="value" select="$val"/>
  </xsl:call-template>
  </td>
</xsl:template>

<xsl:template match="matrixquestion[@type='xorr']/columns/atext" mode="body">
  <xsl:param name="rnumber">0</xsl:param>
  <xsl:variable name="cnumber"><xsl:number/></xsl:variable>
  <xsl:variable name="fnum">
    <xsl:choose>
      <xsl:when test="@id"><xsl:value-of select="@id"/></xsl:when>
      <xsl:otherwise>f<xsl:call-template name="qcounter"/>_<xsl:value-of select="$cnumber"/></xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <td align="center">
  <xsl:call-template name="input-tag">
    <xsl:with-param name="type">radio</xsl:with-param>
    <xsl:with-param name="name" select="$fnum"/>
    <xsl:with-param name="value" select="$rnumber"/>
  </xsl:call-template>
  </td>
</xsl:template>

<xsl:template match="matrixquestion[@type='mixed']/columns/atext" mode="body">
  <xsl:param name="rnumber">0</xsl:param>
  <xsl:variable name="cnumber"><xsl:number/></xsl:variable>
  <xsl:variable name="fnum">
    <xsl:choose>
      <xsl:when test="../../@id"><xsl:value-of select="../../@id"/></xsl:when>
      <xsl:otherwise>f<xsl:call-template name="qcounter"/></xsl:otherwise>
    </xsl:choose>
    <xsl:text>_</xsl:text>
    <xsl:value-of select="$rnumber"/>
    <xsl:text>_</xsl:text>
    <xsl:value-of select="$cnumber"/>
  </xsl:variable>
 
  <td align="center">
  <xsl:choose>
    <xsl:when test="@type='xor'">
      <xsl:variable name="fnum2">
        <xsl:choose>
          <xsl:when test="../../@id"><xsl:value-of select="../../@id"/></xsl:when>
          <xsl:otherwise>f<xsl:call-template name="qcounter"/></xsl:otherwise>
        </xsl:choose>
        <xsl:text>_</xsl:text>
        <xsl:value-of select="$rnumber"/>
      </xsl:variable>

      <xsl:if test="$with-ids">
        <span class="fnum">[<xsl:value-of select="$fnum2"/>]</span>
      </xsl:if>
      <xsl:call-template name="input-tag">
        <xsl:with-param name="type">radio</xsl:with-param>
        <xsl:with-param name="name" select="$fnum2"/>
        <xsl:with-param name="value"><xsl:call-template name="aval" /></xsl:with-param>
      </xsl:call-template>
    </xsl:when>
    <xsl:when test="@type='or'">
      <xsl:if test="$with-ids">
        <span class="fnum">[<xsl:value-of select="$fnum"/>]</span>
      </xsl:if>
      <xsl:call-template name="input-tag">
        <xsl:with-param name="type">checkbox</xsl:with-param>
        <xsl:with-param name="value">1</xsl:with-param>
        <xsl:with-param name="name" select="$fnum"/>
      </xsl:call-template>
    </xsl:when>
    <xsl:when test="@type='text'">
      <xsl:call-template name="textinput-tag">
        <xsl:with-param name="name" select="$fnum"/>
      </xsl:call-template>
    </xsl:when>
  </xsl:choose>
  </td>
</xsl:template>

<!-- sections -->

<xsl:template match="section">
  <xsl:variable name="sectionnumber"><xsl:number count="section" from="/"/></xsl:variable>
  <xsl:variable name="sectioncount" select="count(//section)" />

  <div class="section">
    <xsl:attribute name="id">sect<xsl:value-of select="$sectionnumber"/></xsl:attribute>

    <xsl:apply-templates/>

  <!-- buttons -->
  <div class="question" style="width:100%; display:none;vertical-align:middle;">
    <xsl:attribute name="id">buttons<xsl:value-of select="$sectionnumber"/></xsl:attribute>
    <!-- mit div geht das nie 100% richtig -->
    <table style="width:100%">
    <tr><td style="width:33%;">
     <xsl:choose>
     <xsl:when test="$sectionnumber &gt; 1">
     <input type="button" value="|&lt;&lt;">
       <xsl:attribute name="onclick">
         <xsl:text>javascript:endis('sect1','sect</xsl:text><xsl:value-of select="$sectionnumber"/><xsl:text>');javascript:set(1);</xsl:text>
       </xsl:attribute>
     </input>
     </xsl:when>
     <xsl:otherwise>
     <xsl:text>&#160;</xsl:text>
     </xsl:otherwise>
    </xsl:choose>
  </td>
  <td style="width:34%;text-align:center;">
    <xsl:if test="$sectionnumber &gt; 1">
    <input type="button" value="&lt;">
       <xsl:attribute name="onclick">
         <xsl:text>javascript:endis('sect</xsl:text><xsl:value-of select="number($sectionnumber)-1"/><xsl:text>','sect</xsl:text><xsl:value-of select="$sectionnumber"/><xsl:text>');javascript:set(</xsl:text><xsl:value-of select="number($sectionnumber)-1"/><xsl:text>);</xsl:text>
       </xsl:attribute>
     </input>
     </xsl:if>
    <xsl:if test="$sectionnumber &lt; $sectioncount">
    <input type="button" value="&gt;">
       <xsl:attribute name="onclick">
         <xsl:text>javascript:endis('sect</xsl:text><xsl:value-of select="number($sectionnumber)+1"/><xsl:text>','sect</xsl:text><xsl:value-of select="$sectionnumber"/><xsl:text>');javascript:set(</xsl:text><xsl:value-of select="number($sectionnumber)+1"/><xsl:text>);</xsl:text>
       </xsl:attribute>
     </input>
     </xsl:if>
  </td>
  <td style="width:33%; text-align:right;">
     <xsl:if test="$sectionnumber &lt; $sectioncount">
     <input type="button" value="&gt;&gt;|">
       <xsl:attribute name="onclick">
         <xsl:text>javascript:endis('sect</xsl:text><xsl:value-of select="number($sectioncount)"/><xsl:text>','sect</xsl:text><xsl:value-of select="$sectionnumber"/><xsl:text>');javascript:set(</xsl:text><xsl:value-of select="number($sectionnumber)"/><xsl:text>);</xsl:text>
       </xsl:attribute>
     </input>
     </xsl:if>
  </td></tr>
  </table>
  </div>
  </div>
</xsl:template>


<!-- Hilfsroutinen -->
<xsl:template name="input-tag">
  <xsl:param name="type"/>
  <xsl:param name="name"/>
  <xsl:param name="value"/>
  <input>
    <xsl:attribute name="type"><xsl:value-of select="$type"/></xsl:attribute>
    <xsl:attribute name="name"><xsl:value-of select="$name"/></xsl:attribute>
    <xsl:attribute name="value"><xsl:value-of select="$value"/></xsl:attribute>
  </input>
</xsl:template>

<xsl:template name="textinput-tag">
  <xsl:param name="name"/>
  <xsl:if test="$with-ids">
    <span class="fnum">[<xsl:value-of select="$name"/>]</span>
  </xsl:if>
  <input>
    <xsl:attribute name="name"><xsl:value-of select="$name"/></xsl:attribute>
    <xsl:if test="@size">
      <xsl:attribute name="size"><xsl:value-of select="@size"/></xsl:attribute>
    </xsl:if>
    <xsl:if test="@maxlength">
      <xsl:attribute name="maxlength"><xsl:value-of select="@maxlength"/></xsl:attribute>
    </xsl:if>
  </input>
</xsl:template>

<xsl:template name="option-tag">
  <xsl:param name="value"/>
  <option>
    <xsl:attribute name="value"><xsl:value-of select="$value"/></xsl:attribute>
    <xsl:apply-templates/>
  </option>
</xsl:template>

<!-- Durchzureichendes HTML mit Attributen-->

<xsl:template match="p|i|b|br|font|h1|h2|h3|h4|h5|h6|hr|div|img|table|th|tr|td">
  <xsl:copy>
    <xsl:for-each select="@*">
      <xsl:copy/>
    </xsl:for-each>
    <xsl:apply-templates/>
  </xsl:copy>
</xsl:template>

<!-- Alle anderen Element-Knoten, Text wird ausgegeben! -->

<xsl:template match="qtext">
  <xsl:apply-templates/>
</xsl:template>

<xsl:template match="*"/>

</xsl:stylesheet>
