<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:include href="xquestlib.xsl"/>
<xsl:output method="html" encoding="UTF-8" omit-xml-declaration="yes" 
  doctype-public = "-//W3C//DTD HTML 4.01 Transitional//EN"
  doctype-system = "http://www.w3.org/TR/html4/loose.dtd"
/>

<!-- Wurzelknoten -->
<xsl:template match="questionnaire">
  <html>
   <head>
    <title><xsl:value-of select="$title"/><xsl:value-of select="$title"/></title>
    <xsl:call-template name="print_css_style"/>
   </head> 
   <body>
      <h1><xsl:value-of select="$title"/></h1>
  <script language="php">
  $inserts = "";
  $db_host = '<xsl:value-of select="$db_host"/>';
  $db_pass = '<xsl:value-of select="$db_pass"/>';
  $db_user = '<xsl:value-of select="$db_user"/>';
  $db_name = '<xsl:value-of select="$db_name"/>';
  $db_table = '<xsl:value-of select="$db_table"/>';

  <xsl:if test="$with-time">
    $time0 = $_POST['xquest_start'] ? $_POST['xquest_start'] : 0;
    $inserts[] = "xquest_start=\"" .  date("Y-m-d G:i",$time0) . "\"";
    $inserts[] = "xquest_duration=" . intval((time() - $time0));
  </xsl:if>
  
  <xsl:if test="$with-ip">
    $inserts[] = "xquest_ip=\"" .  $_SERVER["REMOTE_ADDR"] . "\"";
  </xsl:if>

  <xsl:if test="$with-user">
    $inserts[] = "xquest_user=\"" .  $_SERVER["REMOTE_USER"] . "\"";
  </xsl:if>

  <xsl:apply-templates/>

  $insert = "insert into $db_table set " . join(",", $inserts);
  @mysql_connect($db_host, $db_user, $db_pass);
  @mysql_select_db($db_name);
  </script>

  <xsl:choose>
  <xsl:when test="@restrict">
    <xsl:if test="@restrict='inline'">
  <script language="php">
       $x=strtolower($_POST['r1'].$_POST['r2']);
       $y=strtolower($_POST['r3'].$_POST['r4']);
       $z=substr(md5($x."<xsl:value-of select="$db_pass"/><xsl:value-of select="$db_table"/>"), 0 ,8);
  </script>
    </xsl:if>
    <xsl:if test="@restrict='url'">
  <script language="php">
       $x=substr($_POST['id'], 0, 8);
       $y=substr($_POST['id'], 8, 8);
       $z=substr(md5($x."<xsl:value-of select="$db_pass"/><xsl:value-of select="$db_table"/>"), 0 ,8);
  </script>
    </xsl:if>
    <xsl:if test="@restrict='inline_short'">
  <script language="php">
       $x=substr($_POST['id'], 0, 4);
       $y=substr($_POST['id'], 4, 2);
       $sec=$x."<xsl:value-of select="$db_pass"/><xsl:value-of select="$db_table"/>";
       $sec=strtoupper(base_convert(substr(base_convert(substr(md5($sec), 0, 8),16,2),-10),2,36));
       if(strlen($sec)==0) $z="00";
       elseif(strlen($sec)==1) $z="0${sec}";
       else $z = substr($sec,0,2);
  </script>
    </xsl:if>
    <xsl:if test="@restrict='user'">
  <script language="php">
       $x="";
       $y=substr($_SERVER['REMOTE_USER'],0,16);
       $z=$_SERVER['REMOTE_USER'];
  </script>
    </xsl:if>
  <script language="php">
       $r=@mysql_query("select * from $db_table where id='$x$y'");
       if ($y != $z ) {
  </script>
  <!-- id falsch -->
    <xsl:apply-templates select="//submit/failid"/>
  <script language="php">
       } else if (mysql_num_rows($r)) {
  <!-- id verwendet -->
  </script>
    <xsl:apply-templates select="//submit/failused"/>
  <script language="php">
       } else {
         $insert = $insert.", id='$x$y'";
         mysql_query($insert);
  </script>
  <!-- erfolgreich -->
    <xsl:apply-templates select="//submit/success"/>
  <script language="php">
         }
  </script>
  </xsl:when>

  <!-- keine restriction -->
  <xsl:otherwise>
  <script language="php">
         mysql_query($insert);
  </script>
  <!-- erfolgreich -->
      <xsl:apply-templates select="//submit/success"/>
  </xsl:otherwise>
  </xsl:choose>

  <xsl:call-template name="print_copyright"/>
   </body>
  </html>
</xsl:template>

<!-- Fragetypen -->
<!-- Einfache Auswahlen --> <!-- Auswahlbereich -->

<xsl:template match="selectquestion|rangequestion">
  <xsl:variable name="fnum"><xsl:call-template name="fnum"/></xsl:variable>
  <xsl:choose>
    <xsl:when test="@type='or'">
      <xsl:apply-templates select="atext"/>
    </xsl:when>
    <xsl:otherwise>
      <xsl:call-template name="insert-num">
        <xsl:with-param name="fnum" select="$fnum"/>
      </xsl:call-template>
      <xsl:apply-templates select="atext/input"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="selectquestion[@type='or']/atext">
  <xsl:variable name="fnum">
    <xsl:call-template name="fnum">
      <xsl:with-param name="default">f<xsl:call-template name="qcounter"/>_<xsl:number count="atext"/></xsl:with-param>
    </xsl:call-template>
  </xsl:variable>
  <xsl:call-template name="insert-num">
    <xsl:with-param name="fnum" select="$fnum"/>
  </xsl:call-template>
  <xsl:apply-templates select="input"/>
</xsl:template>

<xsl:template match="selectquestion[@type='xor' or @type='or']/atext/input">
  <xsl:variable name="fnum">
    <xsl:choose>
      <xsl:when test="(../../@type='or' and ../@id) or (../../@type='xor' and ../../@id)">
        <xsl:if test="../../@type='or'"><xsl:value-of select="../@id"/>_txt</xsl:if>
        <xsl:if test="../../@type='xor'"><xsl:value-of select="../../@id"/>_txt</xsl:if>
      </xsl:when>
      <xsl:otherwise>f<xsl:call-template name="qcounter"/>_<xsl:number count="atext"/>_txt</xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:call-template name="insert-text">
    <xsl:with-param name="fnum" select="$fnum"/>
  </xsl:call-template>
</xsl:template>

<!-- Einzeilige Texteingabe -->
<xsl:template match="textquestion">
  <xsl:variable name="fnum"><xsl:call-template name="fnum"/></xsl:variable>
  <xsl:choose>
    <xsl:when test="descendant::input">
      <xsl:apply-templates select="atext/input"/>
    </xsl:when>
    <xsl:otherwise>
      <xsl:call-template name="insert-text">
        <xsl:with-param name="fnum" select="$fnum"/>
      </xsl:call-template>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="textquestion/atext/input">
  <xsl:variable name="fnum">
    <xsl:call-template name="fnum">
      <xsl:with-param name="default">
        <xsl:text>f</xsl:text>
        <xsl:call-template name="qcounter"/>
        <xsl:if test="count(../../atext/input) &gt; 1">
          <xsl:text>_</xsl:text>
          <xsl:value-of select="count(../preceding-sibling::atext/input | preceding-sibling::input) + 1"/>
        </xsl:if>
      </xsl:with-param>
    </xsl:call-template>
  </xsl:variable>
  <xsl:call-template name="insert-text">
    <xsl:with-param name="fnum" select="$fnum"/>
  </xsl:call-template>
</xsl:template>

<!-- Mehrzeilige Texteingabe -->
<xsl:template match="textareaquestion">
  <xsl:variable name="fnum"><xsl:call-template name="fnum"/></xsl:variable>
  <xsl:call-template name="insert-text">
    <xsl:with-param name="fnum" select="$fnum"/>
  </xsl:call-template>
</xsl:template>

<!-- Matrixfrage -->

<xsl:template match="matrixquestion[@type='xorr']">
  <xsl:apply-templates select="columns"/>
</xsl:template>

<xsl:template match="matrixquestion[@type='dropdown' or @type='or' or @type='text' or @type='xorc' or @type='mixed']">
  <xsl:apply-templates select="rows"/>
</xsl:template>

<xsl:template match="matrixquestion/rows|matrixquestion/columns">
  <xsl:apply-templates/>
</xsl:template>

<!-- xor spaltenweise -->
<!-- xor zeilenweise -->
<xsl:template match="matrixquestion[@type='xorc']/rows/atext|matrixquestion[@type='xorr']/columns/atext">
  <xsl:call-template name="insert-num">
    <xsl:with-param name="fnum">
      <xsl:call-template name="fnum">
        <xsl:with-param name="default">f<xsl:call-template name="qcounter"/>_<xsl:number/></xsl:with-param>
      </xsl:call-template>
    </xsl:with-param>
  </xsl:call-template>
</xsl:template>

<!-- or, dropdown, text -->
<xsl:template match="matrixquestion[@type='dropdown' or @type='or' or @type='text']/rows/atext">
  <xsl:variable name="rnumber"><xsl:number/></xsl:variable>
  <xsl:apply-templates select="../../columns/atext">
    <xsl:with-param name="rnumber"><xsl:number/></xsl:with-param>
  </xsl:apply-templates>
</xsl:template>

<xsl:template match="matrixquestion[@type='text']/columns/atext|matrixquestion[@type='mixed']/columns/atext[@type='text']">
  <xsl:param name="rnumber">0</xsl:param>
  <xsl:variable name="cnumber"><xsl:number/></xsl:variable>
  <xsl:variable name="f">
    <xsl:choose>
      <xsl:when test="../../@id"><xsl:value-of select="../../@id"/></xsl:when>
      <xsl:otherwise>f<xsl:call-template name="qcounter"/></xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:variable name="fnum"><xsl:value-of select="$f"/>_<xsl:value-of select="$rnumber"/>_<xsl:value-of select="$cnumber"/></xsl:variable>
  <xsl:call-template name="insert-text">
    <xsl:with-param name="fnum" select="$fnum"/>
  </xsl:call-template>
</xsl:template>

<xsl:template match="matrixquestion[@type='dropdown' or @type='or']/columns/atext|matrixquestion[@type='mixed']/columns/atext[@type='or']">
  <xsl:param name="rnumber">0</xsl:param>
  <xsl:variable name="cnumber"><xsl:number/></xsl:variable>
  <xsl:variable name="f">
    <xsl:choose>
      <xsl:when test="../../@id"><xsl:value-of select="../../@id"/></xsl:when>
      <xsl:otherwise>f<xsl:call-template name="qcounter"/></xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:variable name="fnum"><xsl:value-of select="$f"/>_<xsl:value-of select="$rnumber"/>_<xsl:value-of select="$cnumber"/></xsl:variable>
  <xsl:call-template name="insert-num">
    <xsl:with-param name="fnum" select="$fnum"/>
  </xsl:call-template>
</xsl:template>

<xsl:template match="matrixquestion[@type='mixed']/rows/atext">
  <xsl:variable name="rnumber"><xsl:number/></xsl:variable>
  <xsl:if test="../../columns/atext[@type='xor']">
    <xsl:variable name="f">
      <xsl:choose>
        <xsl:when test="../../@id"><xsl:value-of select="../../@id"/></xsl:when>
        <xsl:otherwise>f<xsl:call-template name="qcounter"/></xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="fnum"><xsl:value-of select="$f"/>_<xsl:value-of select="$rnumber"/></xsl:variable>
    <xsl:call-template name="insert-num">
      <xsl:with-param name="fnum" select="$fnum"/>
    </xsl:call-template>
  </xsl:if>
  <xsl:for-each select="../../columns/atext">
    <xsl:if test="@type='text' or @type='or'">
      <xsl:apply-templates select=".">
         <xsl:with-param name="rnumber" select="$rnumber"/>
      </xsl:apply-templates>
    </xsl:if>
 </xsl:for-each>
</xsl:template>

<!-- generische inserts -->

<xsl:template name="insert-text">
  <xsl:param name="fnum"/>
  $inserts[] = "<xsl:value-of select="$fnum"/>=\"" . htmlspecialchars($_POST['<xsl:value-of select="$fnum"/>'])."\"";
</xsl:template>

<xsl:template name="insert-num">
  <xsl:param name="fnum"/>
  $inserts[] = "<xsl:value-of select="$fnum"/>=" . ($_POST['<xsl:value-of select="$fnum"/>']?$_POST['<xsl:value-of select="$fnum"/>']:0);
</xsl:template>

<!-- Abschlusstext -->

<xsl:template match="submit/success|submit/failid|submit/failused">
  <div class="qtext">
  <xsl:copy-of select="node()"/>
  </div>
</xsl:template>

<!-- Alles andere -->
<xsl:template match="section"><xsl:apply-templates/></xsl:template>

<xsl:template match="node()"/>

</xsl:stylesheet>
