<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:include href="xquestlib.xsl"/>
<xsl:output method="text"/>

<!-- Wurzelknoten -->
<xsl:template match="questionnaire">

<xsl:if test="$with-dbcreate">
create database if not exists <xsl:value-of select="$db_name"/>;
</xsl:if>

use <xsl:value-of select="$db_name"/>;

drop table if exists <xsl:value-of select="$db_table"/>;

create table <xsl:value-of select="$db_table"/> (xquest_foo int);

  <xsl:choose>
  <xsl:when test="@restrict='inline' or @restrict='url'">
alter table <xsl:value-of select="$db_table"/> add column (id varchar(16) not null primary key);
  </xsl:when>
  <xsl:when test="@restrict='inline_short'">
alter table <xsl:value-of select="$db_table"/> add column (id varchar(6) not null primary key);
  </xsl:when>
  <xsl:when test="@restrict='user'">
alter table <xsl:value-of select="$db_table"/> add column (id varchar(16) not null primary key);
  </xsl:when>
  </xsl:choose>

  <xsl:if test="$with-time">
alter table <xsl:value-of select="$db_table"/> add column (xquest_start text);
alter table <xsl:value-of select="$db_table"/> add column (xquest_duration int);
  </xsl:if>
  <xsl:if test="$with-ip">
alter table <xsl:value-of select="$db_table"/> add column (xquest_ip text);
  </xsl:if>
  <xsl:if test="$with-user">
alter table <xsl:value-of select="$db_table"/> add column (xquest_user text);
  </xsl:if>

  <xsl:apply-templates/>

alter table <xsl:value-of select="$db_table"/> drop column xquest_foo;

<xsl:if test="$with-dbgrant">
grant insert, select on <xsl:value-of select="$db_name"/>.<xsl:value-of select="$db_table"/> to <xsl:value-of select="$db_user"/>@'%' identified by '<xsl:value-of select="$db_pass"/>';
</xsl:if>
</xsl:template>


<!-- Fragetypen -->
<!-- Einfache Auswahlen --> <!-- Auswahlbereich -->

<xsl:template match="selectquestion|rangequestion">
  <xsl:choose>
    <xsl:when test="@type='or'">
      <xsl:apply-templates/>
    </xsl:when>
    <xsl:otherwise>
      <xsl:call-template name="alter-integer">
        <xsl:with-param name="fnum"><xsl:call-template name="fnum"/></xsl:with-param>
      </xsl:call-template>
      <xsl:apply-templates select="atext/input"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="selectquestion[@type='xor' or @type='or']/atext/input">
  <xsl:call-template name="alter-text">
    <xsl:with-param name="fnum">
      <xsl:choose>
        <xsl:when test="(../../@type='or' and ../@id) or (../../@type='xor' and ../../@id)">
          <xsl:if test="../../@type='or'"><xsl:value-of select="../@id"/>_txt</xsl:if>
          <xsl:if test="../../@type='xor'"><xsl:value-of select="../../@id"/>_txt</xsl:if>
        </xsl:when>
        <xsl:otherwise>f<xsl:call-template name="qcounter"/>_<xsl:number count="atext"/>_txt</xsl:otherwise>
    </xsl:choose>
    </xsl:with-param>
  </xsl:call-template>
</xsl:template>

<xsl:template match="selectquestion[@type='or']/atext">
  <xsl:call-template name="alter-integer">
    <xsl:with-param name="fnum">
      <xsl:call-template name="fnum">
        <xsl:with-param name="default">f<xsl:call-template name="qcounter"/>_<xsl:number count="atext"/></xsl:with-param>
      </xsl:call-template>
    </xsl:with-param>
  </xsl:call-template>
  <xsl:apply-templates select="input"/>
</xsl:template>

<!-- Einzeilige Texteingabe -->
<xsl:template match="textquestion">
  <xsl:choose>
    <xsl:when test="descendant::input">
       <xsl:apply-templates select="atext/input"/>
    </xsl:when>
    <xsl:otherwise>
      <xsl:call-template name="alter-text">
        <xsl:with-param name="fnum"><xsl:call-template name="fnum"/></xsl:with-param>
      </xsl:call-template>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="textquestion/atext/input">
  <xsl:call-template name="alter-text">
    <xsl:with-param name="fnum">
      <xsl:call-template name="fnum">
        <xsl:with-param name="default">
          <xsl:text>f</xsl:text>
          <xsl:call-template name="qcounter"/>
          <xsl:if test="count(../../atext/input) &gt; 1">
            <xsl:text>_</xsl:text>
            <xsl:value-of select="count(../preceding-sibling::atext/input | preceding-sibling::input) + 1"/>
          </xsl:if>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:with-param>
  </xsl:call-template>
</xsl:template>

<!-- Mehrzeilige Texteingabe -->

<xsl:template match="textareaquestion">
  <xsl:call-template name="alter-text">
    <xsl:with-param name="fnum">
      <xsl:call-template name="fnum">
        <xsl:with-param name="default">f<xsl:call-template name="qcounter"/></xsl:with-param>
      </xsl:call-template>
    </xsl:with-param>
  </xsl:call-template>
</xsl:template>

<!-- Matrixfrage -->

<xsl:template match="matrixquestion[@type='xorr']">
  <xsl:apply-templates select="columns"/>
</xsl:template>

<xsl:template match="matrixquestion[@type='dropdown' or @type='or' or @type='text' or @type='xorc' or @type='mixed']">
  <xsl:apply-templates select="rows"/>
</xsl:template>

<xsl:template match="matrixquestion/rows|matrixquestion/columns">
  <xsl:apply-templates/>
</xsl:template>

<!-- xor spaltenweise -->
<!-- xor zeilenweise -->
<xsl:template match="matrixquestion[@type='xorc']/rows|matrixquestion[@type='xorr']/columns">
  <xsl:for-each select="atext">
    <xsl:call-template name="alter-integer">
      <xsl:with-param name="fnum">
        <xsl:call-template name="fnum">
          <xsl:with-param name="default">f<xsl:call-template name="qcounter"/>_<xsl:number/></xsl:with-param>
        </xsl:call-template>
      </xsl:with-param>
    </xsl:call-template>
  </xsl:for-each>
</xsl:template>

<!-- or, dropdown, text, mixed -->
<xsl:template match="matrixquestion[@type='dropdown' or @type='or' or @type='text' or @type='mixed']">
  <xsl:apply-templates select="rows"/>
</xsl:template>

<xsl:template match="matrixquestion[@type='dropdown' or @type='or' or @type='text']/rows/atext">
  <xsl:variable name="rnumber"><xsl:number/></xsl:variable>
  <xsl:apply-templates select="../../columns/atext">
    <xsl:with-param name="rnumber"><xsl:number/></xsl:with-param>
  </xsl:apply-templates>
</xsl:template>

<xsl:template match="matrixquestion[@type='text']/columns/atext|matrixquestion[@type='mixed']/columns/atext[@type='text']">
  <xsl:param name="rnumber">0</xsl:param>
  <xsl:variable name="cnumber"><xsl:number/></xsl:variable>
  <xsl:variable name="f">
    <xsl:choose>
      <xsl:when test="../../@id"><xsl:value-of select="../../@id"/></xsl:when>
      <xsl:otherwise>f<xsl:call-template name="qcounter"/></xsl:otherwise>
    </xsl:choose>
  </xsl:variable> 
  <xsl:call-template name="alter-text">
    <xsl:with-param name="fnum">
      <xsl:value-of select="$f"/>_<xsl:value-of select="$rnumber"/>_<xsl:value-of select="$cnumber"/>
    </xsl:with-param>
  </xsl:call-template>
</xsl:template>

<xsl:template match="matrixquestion[@type='dropdown' or @type='or']/columns/atext|matrixquestion[@type='mixed']/columns/atext[@type='or']">
  <xsl:param name="rnumber">0</xsl:param>
  <xsl:variable name="cnumber"><xsl:number/></xsl:variable>
  <xsl:variable name="f">
    <xsl:choose>
      <xsl:when test="../../@id"><xsl:value-of select="../../@id"/></xsl:when>
      <xsl:otherwise>f<xsl:call-template name="qcounter"/></xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:call-template name="alter-integer">
    <xsl:with-param name="fnum">
      <xsl:value-of select="$f"/>_<xsl:value-of select="$rnumber"/>_<xsl:value-of select="$cnumber"/>
    </xsl:with-param>
  </xsl:call-template>
</xsl:template>

<xsl:template match="matrixquestion[@type='mixed']/rows/atext">
  <xsl:variable name="rnumber"><xsl:number/></xsl:variable>
  <xsl:if test="../../columns/atext[@type='xor']">
    <xsl:variable name="f">
      <xsl:choose>
        <xsl:when test="../../@id"><xsl:value-of select="../../@id"/></xsl:when>
        <xsl:otherwise>f<xsl:call-template name="qcounter"/></xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:call-template name="alter-integer">
      <xsl:with-param name="fnum">
        <xsl:value-of select="$f"/>_<xsl:value-of select="$rnumber"/>
      </xsl:with-param>
    </xsl:call-template>
  </xsl:if>
  <xsl:for-each select="../../columns/atext">
    <xsl:if test="@type='text' or @type='or'">
      <xsl:apply-templates select=".">
         <xsl:with-param name="rnumber" select="$rnumber"/>
      </xsl:apply-templates>
    </xsl:if>
 </xsl:for-each>
</xsl:template>

<!-- generische inserts -->

<xsl:template name="alter-text">
  <xsl:param name="fnum"/>
  alter table <xsl:value-of select="$db_table"/> add column (<xsl:value-of select="$fnum"/> text);
</xsl:template>

<xsl:template name="alter-integer">
  <xsl:param name="fnum"/>
  alter table <xsl:value-of select="$db_table"/> add column (<xsl:value-of select="$fnum"/> integer);
</xsl:template>

<!-- restliche Knoten: HTML, Submit, ... -->
<xsl:template match="section"><xsl:apply-templates/></xsl:template>

<xsl:template match="node()"/>

</xsl:stylesheet>
