<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- version 2.3b vom 12.06.2006 -->
<!-- version 2.3a vom 13.05.2005 -->
<!-- version 2.3 vom 11.04.2005 -->
<!-- version 2.2 vom 28.03.2005 -->
<!-- version 2.1c vom 09.03.2005 -->
<!-- version 2.1b vom 08.02.2005 -->
<!-- version 2.1a vom 03.09.2004 -->
<!-- version 2.1 vom 26.05.2004 -->
<!-- version 2.0 vom 13.05.2004 -->

<xsl:param name="with-ids"/>
<xsl:param name="with-time"/>
<xsl:param name="with-ip"/>
<xsl:param name="with-user"/>
<xsl:param name="with-progress"/>
<xsl:param name="with-fnum">1</xsl:param>
<xsl:param name="delim">,</xsl:param>
<xsl:param name="with-dbcreate">1</xsl:param>
<xsl:param name="with-dbgrant">1</xsl:param>

<xsl:param name="title" select="questionnaire/@title"/>
<xsl:param name="css-stylesheet" select="questionnaire/@css-stylesheet"/>
<xsl:param name="baseurl" select="questionnaire/@baseurl"/>
<xsl:param name="submiturl" select="questionnaire/@submiturl"/>

<xsl:param name="db_table" select="questionnaire/@db_table"/>
<xsl:param name="db_name" select="questionnaire/@db_name"/>
<xsl:param name="db_user" select="questionnaire/@db_user"/>
<xsl:param name="db_pass" select="questionnaire/@db_pass"/>
<xsl:param name="db_host" select="questionnaire/@db_host"/>

<xsl:variable name="_version">XQuest 2.3b</xsl:variable>

<!-- zaehlen aller Fragen -->
<xsl:template name="qcounter">
  <xsl:number count="selectquestion|txtquestion|textquestion|txtareaquestion|textareaquestion|rangequestion|matrixquestion" level="any" />
</xsl:template>

<!-- Liefert eine interne Fragenummer -->
<xsl:template name="fnum">
  <xsl:param name="default"/>
  <xsl:choose>
    <xsl:when test="@id"><xsl:value-of select="@id"/></xsl:when>
    <xsl:when test="$default"><xsl:value-of select="$default"/></xsl:when>
    <xsl:otherwise>f<xsl:call-template name="qcounter"/></xsl:otherwise>
  </xsl:choose>
</xsl:template>

<!-- wenn @value, dann das ausgeben, sonst atext durchzaehlen -->
<xsl:template name="aval">
  <xsl:choose>
    <xsl:when test="@value">
      <xsl:value-of select="@value"/>
     </xsl:when>
    <xsl:otherwise>
      <xsl:number count="atext"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<!-- Copyright ausgeben -->
<!-- Hinweis - eine Modifikation dieser Copyright-Zeile oder eine
Unterdrueckung der Ausgabe in exakt dieser Form fuehrt zu einem Erlischen der
Nutzungsrechte an diesem Programm und ist ein Verstoss gegen das Urheberrecht. -->

<xsl:template name="print_copyright">
  <div align="right">
  <font size="-2">Fragebogen erzeugt mit <a href="http://chu.in-chemnitz.de/xquest"><xsl:value-of select="$_version"/></a></font>
  </div>
</xsl:template>

<!-- CSS einbinden -->

<xsl:template name="print_css_style">
    <style type="text/css">
      div.qtext {background-color: #ffdead; padding: 2pt}
      div.atext {background-color: #ffefd5; padding: 2pt}
      div.stext {background-color: #ffefd5; padding: 2pt; color: blue}
      div.question {border-style: solid; border-width: 1px; border-color: black; margin-top: 1em;}
      span.fnum {color: red; font-weight: bold;}
      td.progon {background-color: #ffdead;font-size:12px;line-height:11px;border:1px solid #d3d3d3; } 
      td.progoff {background-color: white; font-size:12px;line-height:11px;border:1px solid #d3d3d3; }
    </style>
    <xsl:if test="$css-stylesheet">
      <link rel="stylesheet" type="text/css" href="{$css-stylesheet}"/>
    </xsl:if>
</xsl:template>

<!-- qtext ausgeben --> 
<xsl:template name="print_qtext">
  <div class="qtext"><xsl:call-template name="qcounter"/>. <xsl:apply-templates select="qtext"/></div>
</xsl:template>

<!-- veraltete tags -->
<xsl:template match="result">
  <xsl:message terminate="yes">result is deprecated. Use submit!</xsl:message>
</xsl:template>
<xsl:template match="txtquestion">
  <xsl:message terminate="yes">txtquestion is deprecated. Use textquestion!</xsl:message>
</xsl:template>
<xsl:template match="txtareaquestion">
  <xsl:message terminate="yes">txtareaquestion is deprecated. Use textareaquestion!</xsl:message>
</xsl:template>

</xsl:stylesheet>
