<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:include href="xquestlib.xsl"/>
<xsl:output method="html"/>

<xsl:param name="title" select="questionnaire/@title"/>
<xsl:param name="baseurl" select="questionnaire/@baseurl"/>
<xsl:param name="submiturl" select="questionnaire/@submiturl"/>
<xsl:param name="db_table" select="questionnaire/@db_table"/>
<xsl:param name="db_name" select="questionnaire/@db_name"/>
<xsl:param name="db_user" select="questionnaire/@db_user"/>
<xsl:param name="db_pass" select="questionnaire/@db_pass"/>
<xsl:param name="db_host" select="questionnaire/@db_host"/>

<!-- Wurzelknoten -->
<xsl:template match="questionnaire">
  <html>
   <body>
    <script language="php"> 

    <xsl:if test="@restrict='inline' or @restrict='url'">
  function id() {
    $x=substr(uniqid(rand()), 5, 8);
    $sec=$x."<xsl:value-of select="$db_pass"/><xsl:value-of select="$db_table"/>";
    $z=substr(md5($sec), 0, 8);
    $r[]=substr($x, 0, 4); $r[]=substr($x, 4, 4);
    $r[]=substr($z, 0, 4); $r[]=substr($z, 4, 4);
    return $r;
  }
  </xsl:if>

    <xsl:if test="@restrict='inline_short'">
  function short_id() {
    $src=strtoupper(base_convert(substr(base_convert(substr(uniqid(rand()),0,8),16,2),-20),2,36));
    if(strlen($src)==0) $x="0000";
    elseif(strlen($src)==1) $x="000${src}";
    elseif(strlen($src)==2) $x="00${src}";
    elseif(strlen($src)==3) $x="0${src}";
    else $x=substr($src,0,4);

    $sec=$x."<xsl:value-of select="$db_pass"/><xsl:value-of select="$db_table"/>";
    $z=strtoupper(base_convert(substr(base_convert(substr(md5($sec), 0, 8),16,2),-10),2,36));
    if(strlen($z)==0) $res="00";
    elseif(strlen($z)==1) $res="0${z}";
    else $res = substr($z,0,2);
    return $x.$res;
  }
  </xsl:if>

  for ($i=0; $i&lt;15; $i++) {
    echo "<xsl:value-of select="$title"/>";
    <xsl:if test="@restrict='inline'">
       $x=id();
       echo "| ID: $x[0] - $x[1] - $x[2] - $x[3]<br/>";
       echo "<xsl:value-of select="$baseurl"/><br/>";
    </xsl:if>
    <xsl:if test="@restrict='inline_short'">
       $x=short_id();
       echo "| ID: $x <br/>";
       echo "<xsl:value-of select="$baseurl"/><br/>";
    </xsl:if>
    <xsl:if test="@restrict='url'">
       $x=id();
       echo "<br/>";
       echo "<xsl:value-of select="$baseurl"/>?id=$x[0]$x[1]$x[2]$x[3]<br/>";
    </xsl:if>

    if ($i&lt;14) echo "-------------------------<br/>";

  }

  </script>
  </body>
  </html>
</xsl:template>

<!-- Alles andere -->
<xsl:template match="node()"/>
</xsl:stylesheet>
