<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:include href="xquestlib.xsl"/>
<xsl:output method="html" encoding="UTF-8" omit-xml-declaration="yes" 
  doctype-public = "-//W3C//DTD HTML 4.01 Transitional//EN"
  doctype-system = "http://www.w3.org/TR/html4/loose.dtd"
/>

<!-- Wurzelknoten -->
<xsl:template match="questionnaire">
  <html>
  <head>
    <title><xsl:value-of select="$title"/></title>
    <xsl:call-template name="print_css_style"/>
  </head>
  <body>
      <h1>Auswertung: <xsl:value-of select="$title"/></h1>
  <script language="php">

  $db_host = "<xsl:value-of select="$db_host"/>";
  $db_pass = "<xsl:value-of select="$db_pass"/>";
  $db_user = "<xsl:value-of select="$db_user"/>";
  $db_name = "<xsl:value-of select="$db_name"/>";
  $db_table = "<xsl:value-of select="$db_table"/>";
  
  mysql_connect($db_host, $db_user, $db_pass);
  mysql_select_db($db_name);


  $x=mysql_query("select * from $db_table");
  echo "Anzahl: ".mysql_num_rows($x);

  </script>

  <xsl:apply-templates/>

  <xsl:call-template name="print_copyright"/>
  </body>
  </html>
</xsl:template>


<!-- Fragetypen -->
<!-- Einfache Auswahlen -->

<xsl:template match="selectquestion">
  <div class="question">
  <xsl:call-template name="print_qtext"/>
  <xsl:apply-templates select="atext"/>
  <xsl:if test="(@type='xor' or @type='dropdown') and @result-stats='yes'">
    <div class="stext">
    <xsl:call-template name="statistics">
        <xsl:with-param name="name"><xsl:call-template name="fnum"/></xsl:with-param>
    </xsl:call-template>
    </div>
  </xsl:if>
  </div>
</xsl:template>

<xsl:template match="selectquestion[@type='or']/atext">
  <div class="atext">
    <xsl:call-template name="count_vals">
      <xsl:with-param name="name">
        <xsl:call-template name="fnum">
           <xsl:with-param name="default">f<xsl:call-template name="qcounter"/>_<xsl:number count="atext"/></xsl:with-param>
        </xsl:call-template>
      </xsl:with-param>
      <xsl:with-param name="value" select="'1'"/>
    </xsl:call-template>
    : <xsl:apply-templates/>
    <xsl:apply-templates select="input" mode="nachrang"/>
  </div>
</xsl:template>

<xsl:template match="selectquestion[@type='xor']/atext|selectquestion[@type='dropdown']/atext">
  <xsl:variable name="val"><xsl:call-template name="aval"/></xsl:variable>
  <div class="atext">
    <xsl:call-template name="count_vals">
      <xsl:with-param name="name"><xsl:call-template name="fnum"/></xsl:with-param>
      <xsl:with-param name="value"><xsl:value-of select="$val"/></xsl:with-param>
    </xsl:call-template>
    : <xsl:apply-templates/>
  <xsl:apply-templates select="input" mode="nachrang"/>
  </div>
</xsl:template>


<xsl:template match="selectquestion[@type='xor' or @type='or']/atext/input" mode="nachrang">
  <xsl:variable name="fnum">
    <xsl:choose>
      <xsl:when test="(../../@type='or' and ../@id) or (../../@type='xor' and ../../@id)">
        <xsl:if test="../../@type='or'"><xsl:value-of select="../@id"/>_txt</xsl:if>
        <xsl:if test="../../@type='xor'"><xsl:value-of select="../../@id"/>_txt</xsl:if>
      </xsl:when>
      <xsl:otherwise>f<xsl:call-template name="qcounter"/>_<xsl:number count="atext"/>_txt</xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <ol>
    <xsl:call-template name="list_txt">
      <xsl:with-param name="name" select="$fnum"/>
    </xsl:call-template>
  </ol>
</xsl:template>

<!-- Einzeilige Texteingabe -->

<xsl:template match="textquestion">
  <div class="question">
  <xsl:call-template name="print_qtext"/>
  <div class="atext">
  <xsl:choose>
    <xsl:when test="count(descendant::input) &gt; 1">
        <table><tr> <!-- koennte schoener sein! -->
        <xsl:for-each  select="descendant::input">
          <td><ol>
            <xsl:call-template name="list_txt">
              <xsl:with-param name="name">
                <xsl:call-template name="fnum">
                  <xsl:with-param name="default">f<xsl:call-template name="qcounter"/>_<xsl:value-of select="count(../preceding-sibling::atext/input | preceding-sibling::input) + 1"/></xsl:with-param>
                </xsl:call-template>
              </xsl:with-param>
            </xsl:call-template>
          </ol></td>
       </xsl:for-each>
       </tr></table>
    </xsl:when>
    <xsl:otherwise>
      <ol>
      <xsl:call-template name="list_txt">
        <xsl:with-param name="name"><xsl:call-template name="fnum"/></xsl:with-param>
      </xsl:call-template>
      </ol>
    </xsl:otherwise>
  </xsl:choose>
  </div>
  </div>
</xsl:template>

<!-- Mehrzeilige Texteingabe -->
<xsl:template match="textareaquestion">
  <div class="question">
  <xsl:call-template name="print_qtext"/>
  <div class="atext">
  <ol>
    <xsl:call-template name="list_txt">
      <xsl:with-param name="name"><xsl:call-template name="fnum"/></xsl:with-param>
    </xsl:call-template>
  </ol>
  </div>
  </div>
</xsl:template>

<!-- Auswahlbereich -->

<xsl:template match="rangequestion">
  <div class="question">
  <xsl:call-template name="print_qtext"/>
  <div class="atext">
    <xsl:value-of select="@left"/>
    <xsl:call-template name="erzeuge_radio">
      <xsl:with-param name="anzahl">
        <xsl:value-of select="@count"/>
      </xsl:with-param>
      <xsl:with-param name="name">
        <xsl:call-template name="qcounter"/>
      </xsl:with-param>
    </xsl:call-template><xsl:text> </xsl:text>
    <xsl:value-of select="@right"/>
  </div>
  <xsl:if test="@result-stats='yes'">
    <div class="stext">
    <xsl:call-template name="statistics">
      <xsl:with-param name="name"><xsl:call-template name="fnum"/></xsl:with-param>
    </xsl:call-template>
    </div>
  </xsl:if>
  </div>
</xsl:template>

<xsl:template name="erzeuge_radio">
  <xsl:param name="anzahl"/>
  <xsl:param name="name"/>
  <xsl:if test="$anzahl > 0">
    <xsl:call-template name="erzeuge_radio">
      <xsl:with-param name="anzahl" select="$anzahl - 1"/>
      <xsl:with-param name="name" select="$name"/>
    </xsl:call-template><xsl:text> </xsl:text>

    <xsl:call-template name="count_vals">
      <xsl:with-param name="name"><xsl:call-template name="fnum"/></xsl:with-param>
      <xsl:with-param name="value" select="$anzahl"/>
    </xsl:call-template>

   </xsl:if>
</xsl:template>

<!-- Matrixfrage -->

<xsl:template match="matrixquestion">
  <div class="question">
  <xsl:call-template name="print_qtext"/>
  <div class="atext">
  <table border="1">
  <tr><td></td><xsl:apply-templates select="columns" mode="head"/>
  <xsl:if test="@type='xorc' and @result-stats='yes'">
    <td></td>
  </xsl:if>
  </tr>
  <xsl:apply-templates select="rows"/>
  <xsl:if test="@type='xorr' and @result-stats='yes'">
    <td></td>
    <xsl:for-each select="columns/atext">
      <td><div class="stext">
        <xsl:call-template name="statistics">
          <xsl:with-param name="name">
            <xsl:call-template name="fnum">
              <xsl:with-param name="default">f<xsl:call-template name="qcounter"/>_<xsl:number count="atext"/></xsl:with-param>
            </xsl:call-template>
          </xsl:with-param>
        </xsl:call-template>
      </div></td>
    </xsl:for-each>
  </xsl:if>
  </table>
  </div>
  </div>
</xsl:template>

<xsl:template match="columns" mode="head">
  <xsl:apply-templates select="atext" mode="head"/>
</xsl:template>

<xsl:template match="matrixquestion/columns/atext" mode="head">
  <td align="center"><xsl:apply-templates/></td>
</xsl:template>

<xsl:template match="matrixquestion/rows">
 <xsl:for-each select="atext">
    <xsl:variable name="rnumber"><xsl:call-template name="aval"/></xsl:variable>
    <tr><td><xsl:number format="a"/>) <xsl:apply-templates select="." mode="head"/></td>
      <xsl:apply-templates select="../../columns/atext" mode="body">
         <xsl:with-param name="rnumber"><xsl:number/></xsl:with-param>
      </xsl:apply-templates>
      <xsl:if test="../../@type='xorc' and ../../@result-stats='yes'">
        <td>
          <div class="stext"> 
            <xsl:call-template name="statistics">
              <xsl:with-param name="name">
                <xsl:call-template name="fnum">
                  <xsl:with-param name="default">f<xsl:call-template name="qcounter"/>_<xsl:number/></xsl:with-param>
                </xsl:call-template>
              </xsl:with-param>
            </xsl:call-template>
          </div>
        </td>
      </xsl:if>
    </tr>
 </xsl:for-each>
</xsl:template>

<xsl:template match="matrixquestion/rows/atext" mode="head">
  <xsl:apply-templates/>
</xsl:template>

<xsl:template match="matrixquestion[@type='text']/columns/atext" mode="body">
  <xsl:param name="rnumber">0</xsl:param>
  <xsl:variable name="cnumber"><xsl:number/></xsl:variable>
  <td align="left"><ol>
    <xsl:variable name="f">
      <xsl:choose>
        <xsl:when test="../../@id"><xsl:value-of select="../../@id"/></xsl:when>
        <xsl:otherwise>f<xsl:call-template name="qcounter"/></xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="fnum"><xsl:value-of select="$f"/>_<xsl:value-of select="$rnumber"/>_<xsl:value-of select="$cnumber"/></xsl:variable>
    <xsl:call-template name="list_txt">
      <xsl:with-param name="name" select="$fnum"/>
    </xsl:call-template>
  </ol></td>
</xsl:template>

<xsl:template match="matrixquestion[@type='or']/columns/atext" mode="body">
  <xsl:param name="rnumber">0</xsl:param>
  <xsl:variable name="cnumber"><xsl:number/></xsl:variable>
  <td>
    <xsl:variable name="f">
      <xsl:choose>
        <xsl:when test="../../@id"><xsl:value-of select="../../@id"/></xsl:when>
        <xsl:otherwise>f<xsl:call-template name="qcounter"/></xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="fnum"><xsl:value-of select="$f"/>_<xsl:value-of select="$rnumber"/>_<xsl:value-of select="$cnumber"/></xsl:variable>
    <xsl:call-template name="count_vals">
      <xsl:with-param name="name" select="$fnum"/>
      <xsl:with-param name="value" select="'1'"/>
    </xsl:call-template>
  </td>
</xsl:template>

<xsl:template match="matrixquestion[@type='dropdown']/columns/atext" mode="body">
  <xsl:param name="rnumber">0</xsl:param>
  <xsl:variable name="cnumber"><xsl:number/></xsl:variable>
  <td>
    <xsl:variable name="f">
      <xsl:choose>
        <xsl:when test="../../@id"><xsl:value-of select="../../@id"/></xsl:when>
        <xsl:otherwise>f<xsl:call-template name="qcounter"/></xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="fnum"><xsl:value-of select="$f"/>_<xsl:value-of select="$rnumber"/>_<xsl:value-of select="$cnumber"/></xsl:variable>
    <xsl:apply-templates select="../../fields/atext">
       <xsl:with-param  name="name" select="$fnum"/>
    </xsl:apply-templates>
    <xsl:if test="../../@result-stats='yes'">
      <div class="stext">
        <xsl:call-template name="statistics">
          <xsl:with-param  name="name" select="$fnum"/>
        </xsl:call-template>
      </div>
    </xsl:if>
  </td>
</xsl:template>

<xsl:template match="matrixquestion[@type='mixed']/columns/atext" mode="body">
  <xsl:param name="rnumber">0</xsl:param>
  <xsl:variable name="cnumber"><xsl:number/></xsl:variable>
  <td valign="top">

  <xsl:variable name="f">
    <xsl:call-template name="fnum">
      <xsl:with-param name="default">f<xsl:call-template name="qcounter"/></xsl:with-param>
    </xsl:call-template>
  </xsl:variable>

  <xsl:choose>
    <xsl:when test="@type='xor'">
    <xsl:call-template name="count_vals">
      <xsl:with-param name="name"><xsl:value-of select="$f"/>_<xsl:value-of select="$rnumber"/></xsl:with-param>
      <xsl:with-param name="value"><xsl:call-template name="aval" /></xsl:with-param>
    </xsl:call-template>
    </xsl:when>
    <xsl:when test="@type='or'">
      <xsl:call-template name="count_vals">
        <xsl:with-param name="name"><xsl:value-of select="$f"/>_<xsl:value-of select="$rnumber"/>_<xsl:value-of select="$cnumber"/></xsl:with-param>
        <xsl:with-param name="value" select="'1'"/>
      </xsl:call-template>
    </xsl:when>
    <xsl:when test="@type='text'"><ol>
      <xsl:call-template name="list_txt">
     <xsl:with-param name="name"><xsl:value-of select="$f"/>_<xsl:value-of select="$rnumber"/>_<xsl:value-of select="$cnumber"/></xsl:with-param>
      </xsl:call-template>
    </ol>
    </xsl:when>
  </xsl:choose>
  </td>
</xsl:template>

<xsl:template match="fields/atext">
  <xsl:param name="name"/>
  <xsl:variable name="val"><xsl:call-template name="aval"/></xsl:variable>
  <xsl:call-template name="count_vals">
    <xsl:with-param name="name" select="$name"/>
    <xsl:with-param name="value"><xsl:value-of select="$val"/></xsl:with-param>
  </xsl:call-template>
  <xsl:text>: </xsl:text>
  <xsl:apply-templates/><br/>
</xsl:template>

<xsl:template match="matrixquestion[@type='xorc']/columns/atext" mode="body">
  <xsl:param name="rnumber">0</xsl:param>
  <xsl:variable name="cnumber"><xsl:number/></xsl:variable>
  <xsl:variable name="val"><xsl:call-template name="aval"/></xsl:variable>
  <td>
    <xsl:call-template name="count_vals">
      <xsl:with-param name="name">
        <xsl:call-template name="fnum">
          <xsl:with-param name="default">f<xsl:call-template name="qcounter"/>_<xsl:value-of select="$rnumber"/></xsl:with-param>
        </xsl:call-template>
      </xsl:with-param>
      <xsl:with-param name="value"><xsl:value-of select="$val"/></xsl:with-param>
    </xsl:call-template>
  </td>
</xsl:template>

<xsl:template match="matrixquestion[@type='xorr']/columns/atext" mode="body">
  <xsl:param name="rnumber">0</xsl:param>
  <xsl:variable name="cnumber"><xsl:number/></xsl:variable>
  <td>
    <xsl:call-template name="count_vals">
      <xsl:with-param name="name">
        <xsl:call-template name="fnum">
          <xsl:with-param name="default">f<xsl:call-template name="qcounter"/>_<xsl:value-of select="$cnumber"/></xsl:with-param>
        </xsl:call-template>
      </xsl:with-param>
      <xsl:with-param name="value" select="$rnumber"/>
    </xsl:call-template>
  </td>
</xsl:template>

<!-- Hilfsroutinen -->

<!-- sql-anfrage zum zaehlen von vorkommen von wert value in feld name -->

<xsl:template name="count_vals">
  <xsl:param name="name"/>
  <xsl:param name="value"/>
  <script language="php">
    $q = mysql_query("select count(*) from $db_table where <xsl:value-of select="$name"/>=<xsl:value-of select="$value"/>");
    $r=mysql_fetch_array($q);
    echo $r[0];
  </script>
</xsl:template>

<!-- sql-anfragen zum ausgaben aller texte in feld name -->

<xsl:template name="list_txt">
  <xsl:param name="name"/>
  <script language="php">
    $q = mysql_query("select <xsl:value-of select="$name"/> from $db_table"); 
    while ($r = mysql_fetch_array($q)) { 
      echo "<li>$r[0]</li>";
    }
  </script>
</xsl:template>

<xsl:template name="list_txt_n">
  <xsl:param name="name"/>
  <xsl:param name="count"/>
  <script language="php">
    $q = mysql_query("select <xsl:call-template name="namegen">
      <xsl:with-param name="name" select="$name"/>
      <xsl:with-param name="count" select="$count"/>
    </xsl:call-template> from $db_table"); 
    while ($r = mysql_fetch_row($q)) { 
      echo "<tr>"
      foreach ($r as $v) {
        echo "<td>$v</td>";
      }
      echo "</tr>";
    }
  </script>
</xsl:template>

<xsl:template name="namegen">
  <xsl:param name="name"/>
  <xsl:param name="count"/>
  <xsl:choose>
    <xsl:when test="$count &gt; 1">
      <xsl:call-template name="namegen">
        <xsl:with-param name="name" select="$name"/>
        <xsl:with-param name="count" select="$count - 1"/>
      </xsl:call-template>
      <xsl:text>,</xsl:text><xsl:value-of select="$name"/><xsl:value-of select="$count"/>
    </xsl:when>
    <xsl:when test="$count = 1">
      <xsl:value-of select="$name"/><xsl:value-of select="$count"/>
    </xsl:when>
  </xsl:choose>
</xsl:template>

<!-- sql-anfragen zum ausgaben der statistik ueber auswahlfragen -->
<xsl:template name="statistics">
  <xsl:param name="name"/>
  <script language="php">
      $q = mysql_query("select avg(<xsl:value-of select="$name"/>), stddev(<xsl:value-of select="$name"/>) from $db_table");
    $r=mysql_fetch_array($q);
    echo "avg: $r[0], std: $r[1]";
  </script>
</xsl:template>

<!-- Durchzureichendes HTML mit Attributen-->

<xsl:template match="p|i|b|br|font|h1|h2|h3|h4|h5|h6|hr|div|img|table|th|tr|td">
  <xsl:copy>
    <xsl:for-each select="@*">
      <xsl:copy/>
    </xsl:for-each>
    <xsl:apply-templates/>
 </xsl:copy>
</xsl:template>

<!-- Alle anderen Element-Knoten, Text wird ausgegeben! -->

<xsl:template match="qtext|section">
  <xsl:apply-templates/>
</xsl:template>

<xsl:template match="*"/>

</xsl:stylesheet>
